 ; Ŀ
 ;   Prawn - Put a stamp and permit into a drawing.                        
 ;   There is no C:Prawn - this is to be called from a stamp inserter.     
 ;   This routine requires the files Puss.lsp and Misps.lsp.               
 ;   Copyright 1994, 2001, 2003, 2004, 2006 - 2010 by Rocket Software Ltd. 
 ;   The subroutine Fishth places the block on the layer whose name is     
 ;   the last argument, if this is nil then the block is placed on the     
 ;   layer containing the block which is used to find the position.        
 ;   Currently this is set to 0.                                           
 ;   This routine should not be construed to condone prawnography.         
 ; 

 ; Ŀ
 ;   Blosc - fit and position a block within a box.                        
 ;   Arguments: Cent, the box centre point.                                
 ;              Desx, the box width.                                       
 ;              Desy, the box height.                                      
 ;              Enam, the entity name of the block.                        
 ;   Calls Puss to find the size of the block.                             
 ;   Returns nothing.                                                      
 ; 
 (DEFUN BLOSC (cent desx desy enam / mxlst sub gnulst widf hite blcen scalfc)
  (load "puss")
  (setq mxlst (puss enam))
 ; Ŀ
 ;   Empty blocks (or all atts, etc.) return (nil nil nil nil).            
 ;   So make sure there are no ()s in the list.                            
 ; 
  (while (setq sub (car mxlst))
         (setq mxlst (cdr mxlst))
         (if (null sub) (setq sub 0))
         (setq gnulst (append gnulst (list sub))))
  (setq mxlst gnulst)
  (if (null mxlst)
      (progn
           (setq mxlst '(0 0 0 0))
           (setq bnam (cdr (assoc 2 (entget enam))))
           (prompt (strcat "\nBad scale data in block " bnam))))
 ; Ŀ
 ;   Get a width and a height, make sure that neither one is zero.         
 ; 
  (setq widf (- (car mxlst) (cadr mxlst)))
  (if (= widf 0) (setq widf 1))
  (setq hite (- (caddr mxlst) (cadddr mxlst)))
  (if (= hite 0) (setq hite 1)) ; i.e. a text string containing only a dash
 ; Ŀ
 ;   Get the block centrepoint.                                            
 ; 
  (setq blcen (list (/ (+ (car mxlst) (cadr mxlst)) 2)
                    (/ (+ (caddr mxlst) (cadddr mxlst)) 2)))
 ; Ŀ
 ;   Centre the scaled block within the box.                               
 ; 
  (command ".move" enam "" blcen cent)
 ; Ŀ
 ;   Calculate whether scaling the x up to the width or the y up to the    
 ;   height would produce the smallest scale factor, use that.             
 ; 
  (setq scalfc (min (/ desx widf) (/ desy hite)))
  (command ".scale" enam "" cent scalfc)
 (princ))
 ; Ŀ
 ;   Blosc end.                                                            
 ; 

 ; Ŀ
 ;   Coux - get hopefully unique block data for a named block definition.  
 ;   Argument: Blnam, a block name.                                        
 ;   Calls nothing.                                                        
 ;   Returns a list: (number_of_entities                                   
 ;                    number_of_attdefs                                    
 ;                    distance_from_insertion_to_closest_att               
 ;                    att_tag  att_tag ...)                                
 ; 
 (DEFUN COUX (blnam / bokhed enam subs entt malist atts dmin dizz)
 ; Ŀ
 ;   Get the block head entity.                                            
 ; 
  (setq bokhed (tblsearch "block" blnam))
 ; Ŀ
 ;   Get the first subentity name.                                         
 ; 
  (setq enam (cdr (assoc -2 bokhed)))
  (setq pa (cdr (assoc 10 bokhed)))
  (setq subs 0)
  (setq atts 0)
  (while enam
         (setq subs (1+ subs))
         (setq entt (entget enam))
         (if (= (cdr (assoc 0 entt)) "ATTDEF")
             (progn
                  (setq atts (1+ atts))
 ; Ŀ
 ;   Get the entity insertion point.  Note that this is the real           
 ;   insertion, not necessarily the ten point.  Also note that the two     
 ;   seem to be the same, apparently an attdef reads - when in a block     
 ;   definition, which is what we are reading here, not the insertion -    
 ;   as being empty, so the ten and eleven points are the same.            
 ;   The spit call is left in in case this changes.                        
 ; 
                  (setq pat (spit entt))
                  (setq dizz (distance pa pat))
                  (if (or (null dmin) (< dizz dmin))
                      (setq dmin dizz))
                  (setq malist (cons (cdr (assoc 2 entt)) malist))))
         (setq enam (entnext enam)))
 ; Ŀ
 ;   Return the subentity block name list.                                 
 ; 
 (list subs atts dmin (reverse malist)))
 ; Ŀ
 ;   Coux end.                                                             
 ; 

 ; Ŀ
 ;   Deeb - see if a D-Bord-E is ... which one it is.                      
 ;   Currently not called - see Coux.                                      
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns T if the insertion is in the lower left corner, else nil.     
 ; 
 (DEFUN DEEB (/ disc blnam ss enam pblock patt)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
  (setq blnam "d-bord-e")
  (if (and (tblsearch "block" blnam)
           (setq ss (ssget "x" (list (cons 2 blnam)))))
      (progn
           (setq enam (ssname ss 0))
           (setq pblock (cdr (assoc 10 (entget enam))))
           (setq patt (cdr (assoc 10 (entget (entnext enam)))))))
 (if (> (distance patt pblock) (* disc 60)) T))
 ; Ŀ
 ;   Deeb end.                                                             
 ; 

 ; Ŀ
 ;   Draed - erase and purge blocks named in a list.                       
 ;   Arguments: Blist, a list of block names.                              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN DRAED (blist / blnam ss)
  (setq num 0)
  (while (and blist (setq blnam (nth num blist)))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 blnam))))
             (command ".erase" ss ""))
         (command "-purge" "block" blnam "n"))
 (princ))
 ; Ŀ
 ;   Draed end.                                                            
 ; 

 ; Ŀ
 ;   Fishth - find a block or blocks, insert another block nearby.         
 ;   Arguments: Blnam, a block name (the one to find).                     
 ;              Othnam, another block name (the one to insert).            
 ;              Ofx, an X offset.                                          
 ;              Ofy, a Y offset.                                           
 ;              Bsiz, a desired block size in drawing units.               
 ;              Laya, a layer name, if nil use the block layer.            
 ;   Calls sculpt.                                                         
 ;   Returns T if anything was found, else nil.                            
 ; 
 (DEFUN FISHTH (blnam othnam ofx ofy bsiz laya / ss sso num enam entt ctab
                                                                      layy)
  (if (and blnam othnam (tblsearch "block" blnam)
           (setq ss (ssget "x" (list (cons 2 blnam)))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if laya
                      (setq layy laya)
                      (setq layy (cdr (assoc 8 entt))))
 ; Ŀ
 ;   See which space each title block occupies, go to that space.          
 ; 
                  (setvar "ctab" (setq ctab (cdr (assoc 410 entt))))
                  (if (/= (strcase ctab t) "model")
                      (command ".pspace"))
                  (if (setq sso (ssget "x" (list (cons 2 othnam))))
                      (command ".erase" sso ""))
                  (setvar "clayer" layy)
                  (sculpt enam othnam ofx ofy bsiz))))
 (if ctab t ()))
 ; Ŀ
 ;   Fishth end.                                                           
 ; 

 ; Ŀ
 ;   IDAK - kill and purge all blocks named in a list, detach xrefs.       
 ;   Takes no arguments, returns nothing.  Independent and ruthless.       
 ;   Calls Isxnam as a sop to public opinion.                              
 ;   Xrefs vs. Insertions:                                                 
 ;   If a block is inserted then can't xref it in - must detach.           
 ;   Similarly, if a block is xrefed then can't insert - must erase        
 ;   and purge.                                                            
 ; 
 (DEFUN IDAK (/ ss klisto num blnam)
  (setq klista '("Alta_Colleaux"
                 "beaver"
                 "BC_PEng_mono"
                 "beck"      "bcbeck"    "skbeck"
                 "bozek"     "skbozek"
                 "budd"
                 "checkryn"
                 "dancy"
                 "delind"
                 "eng-rbh"
                 "ExergyPerm"
                 "fast"
                 "freemant"
                 "gemsask"
                 "gondek"
                 "hayden"
                 "henderson" "skhender"
                 "huitema"   "bchuitem"  "quhuitem"  "skhuitem"
                 "ibrahim"
                 "isbister"  "skisbstr"
                 "jajarmi"   "bcjajarmi" "skjajarmi"
                 "johnson"   "bcjohnsn"  "skjohnsn"
                 "jones"     "bcjones"   "skjones"
                 "jorgense"  "skjorgen"
                 "joy"       "bcjoy"     "skjoy"
                 "kurrant"
                 "majer"
                 "macdonel"
                 "mcdougal"
                 "mclenhan"
                 "newman"    "bcnewman"  "qunewman"  "sknewman"
                 "nguyen"
                 "permab"    "permalta"  "permabkp"  "00permit"
                 "permit"
                 "permsask"  "permsask1"
                 "pavan"     "skpavan"
                 "pickel"    "skpickel"
                 "rawlyk"
                 "redko"
                 "sawatzky"  "bcsawat"   "sksawatzky"
                 "slupsky"
                 "smerek"
                 "snowdon"   "bcsnowdn"
                 "ta"
                 "tardif"
                 "warners"
                 "zotzman"
                 "AB - Arnold"    "AB - Cramer"   "AB - Freeman"
                 "AB - Jajarmi"   "AB - Joy"      "AB - Kondics"
                 "AB - Newman"    "AB - Permit"   "AB - Quon"
                 "AB - Robillard" "AB - Velichko" "AB - Warners"
                 "AB - Watts"     "AB - Yee"      "BC - Cramer"
                 "BC - Freeman"   "BC - Kondics"
                 "MB - Carlson"   "MB - Permit"
                 "Peng _Permit_Stamp_CNRL TB"
                 "Peng _Permit_Stamp_Encana TB"
                 "Peng _Permit_Stamp_Huskey TB"
                 "Peng _Permit_Stamp_Tridyne TB"
                 "SK - Cramer"    "SK - Freeman"  "SK - Kondics"
                 "SK - Newman"    "SK - Permit"   "SK - Velichko"))
 ; Ŀ
 ;   Step through the block list and find a way to get rid of each one.    
 ; 
  (setq num 0)
  (while (setq blnam (nth num klista))
         (setq num (1+ num))
         (if (tblsearch "block" blnam)
             (progn
 ; Ŀ
 ;   If the block is an xref then detach it.                               
 ; 
                  (if (isxnam blnam)
                      (command "-xref" "d" blnam))
 ; Ŀ
 ;   If there are still any copies then either they were normal blocks     
 ;   or the xref was nested and can't be detached, so erase them.          
 ; 
                  (if (and (tblsearch "block" blnam)
                           (setq ss (ssget "X" (list (cons 2 blnam)))))
                      (command "erase" ss ""))
 ; Ŀ
 ;   If the block is still in the block tables and it isn't an xref then   
 ;   purge it.                                                             
 ; 
                  (if (and (tblsearch "block" blnam)
                           (not (isxnam blnam)))
                      (command "-purge" "block" blnam "n")))))
 (princ))
 ; Ŀ
 ;   Idak end.                                                             
 ; 

 ; Ŀ
 ;   Isxnam: see if a given block is an xref.                              
 ;   Argument: Blnam, the block name.                                      
 ;   Returns T: it was an xref, or nil: it wasn't, or no such block is     
 ;   is defined in the drawing.                                            
 ; 
 (DEFUN ISXNAM (blnam / isxrf xp dat)
  (if (setq dat (tblsearch "block" blnam))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf (logand xp 4))))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxnam end.                                                           
 ; 

 ; Ŀ
 ;   Lath - find the first layer which isn't off, locked, or frozen.       
 ;   Takes no arguments.                                                   
 ;   Returns a layer name.                                                 
 ; 
 (DEFUN LATH (/ rew oklay lanam)
  (setq rew t)
  (while (and (null oklay) (setq lanam (tblnext "layer" rew)))
         (if (layp lanam)
             (setq rew ())
             (setq oklay lanam)))
 oklay)
 ; Ŀ
 ;   Lath end.                                                             
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil - It's ok or doesn't exist.       
 ; 
 (DEFUN LAYP (lanam / llist sev col frizp lockp offp stalst)
  (if (setq llist (tblsearch "layer" lanam))
      (progn
           (setq sev (cdr (assoc 70 llist)))
           (setq col (cdr (assoc 62 llist)))
           (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
           (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
           (if (minusp col) (setq stalst (cons "off" stalst)))))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Sculpt - install a block in a position expressed as an     
 ;   offset from the insertion point of another block and at a given       
 ;   size.                                                                 
 ;   Arguments: Enam, the main (typically tb) block ename.                 
 ;              Blnam, the name of the block to insert.                    
 ;              Xoff, the X offset from the block insertion point.         
 ;              Yoff, the Y offset.                                        
 ;              Bsiz, the block size for a tb scale of 1.                  
 ;   Does nothing if the block name is nil.                                
 ;   Returns nothing, calls your mama.  And Blosc.                         
 ; 
 (DEFUN SCULPT (enam blnam xoff yoff bsiz / osna dsxp dsyp entt pa ds)
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0) 
  (setq entt (entget enam))
  (setq pa (cdr (assoc 10 entt)))
  (setq bsiz (* bsiz (setq ds (cdr (assoc 41 entt)))))
  (setq dsxp (+ (car pa) (* xoff ds)))
  (setq dsyp (+ (cadr pa) (* yoff ds)))
  (cond ((findfile (strcat blnam ".dwg"))
         (command "insert" (strcat blnam "=") pa "" "" "")
         (while (= 1 (getvar "cmdactive")) (command " "))
         (blosc (list dsxp dsyp) bsiz bsiz (entlast)))
        ((tblsearch "block" blnam)
         (prompt (strcat "\nExternal file for " blnam " not found.  "
                         "Using the definition in the drawing."))
         (command "insert" blnam pa "" "" "")
         (while (= 1 (getvar "cmdactive")) (command " "))
         (blosc (list dsxp dsyp) bsiz bsiz (entlast)))
        (t
         (prompt (strcat "\n** Block " blnam " isn't available. **"))))
  (setvar "osmode" osna) 
 (princ))
 ; Ŀ
 ;   Subroutine Sculpt end.                                                
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Prawn.                                                                
 ; 
 (DEFUN PRAWN (beaver permit / blizt blnam stanam ofx ofy num folio lenah
                                                                    trisub)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Kill any existing stamps.  Idak is fast but relies on an internal     
 ;   list, which hangman doesn't.  Idak is more certain for blocks it      
 ;   knows, Hangman is more universal but may miss oddball blocks.         
 ;   Hang would be faster than Hangman and also purges block definitions.  
 ; 
  (idak)
;  (c:hangman)
 ; Ŀ
 ;   Make the list of lists of title block and insertion data.             
 ;   The sublist format is:                                                
 ;     Main block name.                                                    
 ;     Block to insert name.                                               
 ;     X offset from insertion of the title block.                         
 ;     Y offset.  (The offsets are for the centre of the block rather      
 ;                 than the insertion point.)                              
 ;     Desired inserted block size in drawing units.                       
 ;   There will typically be two sublists for each title block, but this   
 ;   doesn't have to be so.                                                
 ;   All sizes and distances will be adjusted automatically block scale.   
 ;   Special case blocks (different blocks with the same name) are added   
 ;   later.  Unique blocks should be added here.                           
 ; 
  (if (and (tblsearch "block" "Tridyne_tb_d")
           (setq ss (ssget "x" (list (cons 2 "Tridyne_tb_d")))))
      (progn
           (setq atnum (cadr (coux "Tridyne_tb_d")))
           (cond ((equal atnum 81)
                  (setq blizt (list (list "Tridyne_tb_d"
                                           beaver 236.75 36.0223 42.5)
                                    (list "Tridyne_tb_d"
                                           permit 316.7500 36.1741 63.5))))
                 (t      ; 95 attributes
                  (setq blizt (list (list "Tridyne_tb_d" beaver 189 31 42.5)
                              (list "Tridyne_tb_d" permit 254 33 63.5)))))))
 ; Ŀ
 ;   Allow for the two different D-Bord-E blocks.                          
 ;   No: Coux should let one allow for a variety.  Unfortunately this      
 ;   means doing an ssget to make the list, then another later ... can     
 ;   this be avoided?  Without too much complexity or difficult updating?  
 ; 
  (if (and (tblsearch "block" "d-bord-e")
           (setq ss (ssget "x" (list (cons 2 "d-bord-e")))))
      (progn
           (setq lenah (caddr (coux "d-bord-e")))
           (cond ((equal lenah 422 1)
                  (setq trisub (list (list "D-Bord-E" beaver 335 38 42.5)
                                     (list "D-Bord-E" permit 390 38 51))))
                 ((equal lenah 242.7 1)
                  (setq trisub (list (list "D-Bord-E" beaver 133 36.5 44)
                                     (list "D-Bord-E" permit 197 36.5 63.5))))
                 ((equal lenah 434.6 1)
                  (setq trisub (list (list "D-Bord-E" beaver 173 36.5 44)
                                     (list "D-Bord-E" permit 237 36.5 63.5))))
                 (t
                  (setq trisub (list (list "D-Bord-E" beaver 133 36 44)
                                     (list "D-Bord-E" permit 197 36.5 63.5)))))
           (setq blizt (append blizt trisub))))
 ; Ŀ
 ;   Border.  Which imbecile did this?                                     
 ; 
  (if (and (tblsearch "block" "border")
           (setq ss (ssget "x" (list (cons 2 "border")))))
      (setq blizt (append blizt
                    (list (list "border" beaver 706.95 49 45)
                          (list "border" permit 644.05 49.3 64)))))
 ; Ŀ
 ;   Bord_A1.                                                              
 ; 
  (if (and (tblsearch "block" "bord_a1")
           (setq ss (ssget "x" (list (cons 2 "bord_a1")))))
      (setq blizt (append blizt
                    (list (list "bord_a1" beaver 647.5 45.1 42)
                          (list "bord_a1" permit 590.5 45.25 59)))))
 ; Ŀ
 ;   HORZ_2DbordA1.                                                        
 ;   Note that the distances and scales are divided by 1000, the block     
 ;   being inserted at 1000 x Dimscale.                                    
 ; 
  (if (and (tblsearch "block" "horz_2dborda1")
           (setq ss (ssget "x" (list (cons 2 "horz_2dborda1")))))
      (setq blizt (append blizt
                    (list (list "horz_2dborda1" beaver 0.751 0.1747 0.042)
                          (list "horz_2dborda1" permit 0.8175 0.174 0.065)))))
 ; Ŀ
 ;   "Pel D Size" - similar to Bord_A1.                                    
 ;   Hint to people making title blocks - steal one and change the name.   
 ;   Don't mess with it because you don't know what you're doing.          
 ; 
  (if (and (tblsearch "block" "pel d size")
           (setq ss (ssget "x" (list (cons 2 "pel d size")))))
      (setq blizt (append blizt
                    (list (list "pel d size" beaver 643.5 45 42)
                          (list "pel d size" permit 584.5 45.25 54)))))
 ; Ŀ
 ;   "Pel D Size(Color)" - similar to Pel D Size.  Amazingly.              
 ; 
  (if (and (tblsearch "block" "PEL D Size(Color)")
           (setq ss (ssget "x" (list (cons 2 "PEL D Size(Color)")))))
      (setq blizt (append blizt
                    (list (list "PEL D Size(Color)" beaver 643.5 45 42)
                          (list "PEL D Size(Color)" permit 584.5 45.25 54)))))
 ; Ŀ
 ;   "New Pel D Size" - ...                                                
 ; 
  (if (and (tblsearch "block" "New PEL D Size")
           (setq ss (ssget "x" (list (cons 2 "New PEL D Size")))))
      (setq blizt (append blizt
                    (list (list "New PEL D Size" beaver 643.5 45 42)
                          (list "New PEL D Size" permit 584.5 45.25 54)))))
 ; Ŀ
 ;   Shawn - this seems to be mostly a copy of Bord_A1.                    
 ;   So this is imbecilic on numerous counts.                              
 ; 
  (if (and (tblsearch "block" "shawn")
           (setq ss (ssget "x" (list (cons 2 "shawn")))))
      (setq blizt (append blizt
                    (list (list "shawn" beaver 647.5 45.1 42)
                          (list "shawn" permit 590.5 45.25 59)))))
 ; Ŀ
 ;   Enerplus: TitleA1a.                                                   
 ; 
  (if (and (tblsearch "block" "titlea1a")
           (setq ss (ssget "x" (list (cons 2 "titlea1a")))))
      (setq blizt (append blizt
                    (list (list "titlea1a" beaver 279 43 46)
                          (list "titlea1a" permit 216 43 64)))))
 ; Ŀ
 ;   Exergy.  Probably.  Or Williams?                                      
 ; 
  (if (and (tblsearch "block" "RWTitleBlock")
           (setq ss (ssget "x" (list (cons 2 "RWTitleBlock")))))
      (setq blizt (append blizt
                    (list (list "RWTitleBlock" beaver 643.6 44.6 41)
                          (list "RWTitleBlock" permit 584.5 45.25 56)))))
 ; Ŀ
 ;   "8.5x11 Title Block" - descriptive.  Exergy again?                    
 ; 
  (if (and (tblsearch "block" "8.5x11 Title Block")
           (setq ss (ssget "x" (list (cons 2 "8.5x11 Title Block")))))
      (setq blizt (append blizt
                    (list (list "8.5x11 Title Block" beaver 288 151.5 42)
                          (list "8.5x11 Title Block" permit 357.5 152.5 80)))))
 ; Ŀ
 ;   Gemini - GC_A1_Titleblock.                                            
 ; 
  (if (and (tblsearch "block" "GC_A1_Titleblock")
           (setq ss (ssget "x" (list (cons 2 "GC_A1_Titleblock")))))
      (setq blizt (append blizt
                    (list (list "GC_A1_Titleblock" beaver 579.15 30.0 54)
                          (list "GC_A1_Titleblock" permit 645.15 30.375 55)))))
 ; Ŀ
 ;   Novagas - NCLTTLD.                                                    
 ; 
  (if (and (tblsearch "block" "nclttld")
           (setq ss (ssget "x" (list (cons 2 "nclttld")))))
      (setq blizt (append blizt
                    (list (list "nclttld" beaver 501.75 40.75 42)
                          (list "nclttld" permit 556.8 41.25 60)))))
 ; Ŀ
 ;   Novagas - NCLTTLD1.  I'm sure this was necessary.                     
 ; 
  (if (and (tblsearch "block" "nclttld1")
           (setq ss (ssget "x" (list (cons 2 "nclttld1")))))
      (setq blizt (append blizt
                    (list (list "nclttld1" beaver 501.75 40.75 42)
                          (list "nclttld1" permit 556.8 41.25 60)))))
 ; Ŀ
 ;   Paramount: Paramount_ENG3_tb.                                         
 ; 
  (if (and (tblsearch "block" "Paramount_ENG3_tb")
           (setq ss (ssget "x" (list (cons 2 "Paramount_ENG3_tb")))))
      (setq blizt (append blizt
                    (list (list "Paramount_ENG3_tb" beaver 420.74 43.93 56)
                          (list "Paramount_ENG3_tb" permit 500.24 44.74 80)))))
 ; Ŀ
 ;   Penn West.                                                            
 ; 
  (if (and (tblsearch "block" "PennWest TB_D Size-MS")
           (setq ss (ssget "x" (list (cons 2 "PennWest TB_D Size-MS")))))
      (setq blizt (append blizt
                    (list (list "PennWest TB_D Size-MS" beaver 488 41 42)
                          (list "PennWest TB_D Size-MS" permit 564 42 64)))))
 ; Ŀ
 ;   Provident.                                                            
 ; 
  (if (and (tblsearch "block" "Provident TB D Size")
           (setq ss (ssget "x" (list (cons 2 "Provident TB D Size")))))
      (setq blizt (append blizt
                    (list (list "Provident TB D Size" beaver 642.5 45.4 42)
                          (list "Provident TB D Size" permit 584.5 45.5 54)))))
 ; Ŀ
 ;   Tcmtb.  And we're not talking about where this came from.             
 ; 
  (if (and (tblsearch "block" "tcmtb")
           (setq ss (ssget "x" (list (cons 2 "tcmtb")))))
      (setq blizt (append blizt
                    (list (list "tcmtb" beaver 642.5 45.6 42)
                          (list "tcmtb" permit 584.5 45.5 54)))))
 ; Ŀ
 ;   "Wec Dsize Metric".                                                   
 ; 
  (if (and (tblsearch "block" "wec dsize metric")
           (setq ss (ssget "x" (list (cons 2 "wec dsize metric")))))
      (setq blizt (append blizt
                    (list (list "wec dsize metric" beaver 337 32 50)
                          (list "wec dsize metric" permit 259 31 80)))))
 ; Ŀ
 ;   See if a title block can be found.                                    
 ; 
  (setq num 0)
  (while (and blizt (setq blsub (nth num blizt)))
         (setq num (1+ num))
         (setq blnam (car blsub))
         (if (tblsearch "block" blnam)
             (progn
                  (setq stanam (cadr blsub))
                  (setq ofx (caddr blsub))
                  (setq ofy (cadddr blsub))
                  (setq bsiz (nth 4 blsub))
                  (if (fishth blnam stanam ofx ofy bsiz "0")
                      (setq folio (cons stanam folio))))))
 ; Ŀ
 ;   Print a warning if no title block was found, mostly for debugging.    
 ;   This isn't conclusive: a title block may be defined but not inserted. 
 ; 
  (if (null folio) (write-line "\nNo Title Block Found."))
 ; Ŀ
 ;   Erase and purge any blocks which were inserted.                       
 ;   This isn't a good idea unless the plot command was called before now. 
 ;   Note that Draed doesn't have an internal list and is thus faster      
 ;   than Idak, it is included so that the calling program can use it to   
 ;   erase and purge the stamp blocks after plotting, if desired.          
 ; 
 ; (draed folio)  ; this might be dumb since they were just inserted.
 (princ))
 ; Ŀ
 ;   Prawn End.                                                            
 ; 
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
